 ; Ŀ
 ;   Du - routine to write a block updater routine.                        
 ;   Copyright 1999, 2003 by Rocket Software Ltd.                          
 ;                                                                         
 ;   The user selects attributes, the routine saves the values and writes  
 ;   a routine which finds the same block (typically a title block, as it  
 ;   stands it will only do one of a given type of block, although it      
 ;   probably wouldn't be difficult to revamp) and puts the same values    
 ;   into the selected attributes.                                         
 ;   Updated to allow selection of attributes to empty.                    
 ;   Caution: assumes that all attributes are in the same block as the     
 ;   first one selected, although this could be changed.                   
 ;                                                                         
 ;   Programming:                                                          
 ;   1. Think of something that you want to do.                            
 ;   2. See if you really understand what you are after.                   
 ;   3. Design a way to do it that makes sense.                            
 ;   4. Find a way to tell the computer what to do that is less            
 ;      trouble than doing it yourself.                                    
 ;   5. Write the code.                                                    
 ; 

 ; Ŀ
 ;   Bottle - write a boxed file header.                                   
 ;   Arguments: Lognam - the filename to put the header in.                
 ;              Strlst - the list of strings to write, one per line.       
 ; 
 (DEFUN BOTTLE (lognam strlst / aa bb cc thestr newlst lognam fn)
  (setq aa "")
  (setq bb (strcat " ; " aa aa ""))
  (setq cc (strcat " ; " aa aa ""))
  (while (setq thestr (car strlst))
         (setq strlst (cdr strlst))
         (setq thestr (strcat " ;   " thestr))
         (while (< (strlen thestr) 76) (setq thestr (strcat thestr " ")))
         (setq thestr (strcat thestr ""))
         (setq newlst (append newlst (list thestr))))
  (setq fn (open lognam "w"))
  (princ bb fn)
  (while (setq thestr (car newlst))
         (setq newlst (cdr newlst))
         (princ (strcat "\n" thestr) fn))
  (princ (strcat "\n" cc "\n") fn)
  (close fn))
 ; Ŀ
 ;   Bottle end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Nopth - remove the path from a filename.                   
 ; 
 (DEFUN NOPTH (tt / pos)
  (setq pos (strlen tt))                          ; start at end of the string
  (while (< 0 pos)
         (if (or (= (substr tt pos 1) (chr 92))   ; if char = \
                 (= (substr tt pos 1) ":"))       ; if char = :
             (progn
                  (setq tt (substr tt (1+ pos)))  ; then set tt to all after
                  (setq pos 1)))                  ;  and set pos to first
         (setq pos (1- pos)))                     ; set pos to previous
 tt)
 ; Ŀ
 ;   Nopth end.                                                            
 ; 

 ; Ŀ
 ;   Du.                                                                   
 ; 
 (DEFUN C:DU (/ code1 ss code2 num code3 enam esav entt val tagg gnu lspnam
                prognm tex atsav e1 atnam datlst texlst blanam aa bb fn sub)
  (setvar "cmdecho" 0)
  (setq code1 '(setq ss (ssget "X" (list (cons 2 blanam)))))
  (setq code2 '(setq num 0))
  (setq code3 '
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq esav enam)
         (while (/= (cdr (assoc 0 (setq entt (entget (setq enam
                                                 (entnext enam)))))) "SEQEND")
                (setq val (assoc 1 entt))
                (setq tagg (cdr (assoc 2 entt)))
                (if (setq gnu (cdr (assoc tagg datlst)))
                    (entmod (subst (cons 1 gnu) val entt))))
         (entupd esav)))
 ; Ŀ
 ;   Get the name for the new routine.                                     
 ; 
  (setq lspnam (getfiled "Name of Lisp to create: " "" "lsp" 1))
 ; Ŀ
 ;   Make the program name.                                                
 ; 
  (setq prognm (nopth lspnam))  
  (if (= (strcase (substr prognm (- (strlen prognm) 3)) t) ".lsp")
      (setq prognm (substr prognm 1 (- (strlen prognm) 4))))
 ; Ŀ
 ;   Get Attributes and values to put in them, save to the list Datlst.    
 ; 
  (while (setq tex (nentsel "\nSelect attributes to re-value: "))
         (if (= "ATTRIB" (cdr (assoc 0 (entget (car tex)))))
             (progn
 ; Ŀ
 ;   Save the ename of the first attribute selected so that the parent     
 ;   block name can be extracted.                                          
 ; 
                  (if (null atsav) (setq atsav (car tex)))
                  (princ (cdr (assoc 1 (setq e1 (entget (car tex))))))
 ; Ŀ
 ;   Highlight the attribute so that the user doesn't pick it again.       
 ; 
                  (redraw (setq enam (cdr (assoc -1 e1))) 3)
                  (setq val (cdr (assoc 1 e1)))
                  (setq atnam (cdr (assoc 2 e1)))
                  (setq datlst (cons (cons atnam val) datlst))
 ; Ŀ
 ;   Save attribute enames so that they can be de-highlighted.             
 ; 
                  (setq texlst (cons enam texlst)))))
 ; Ŀ
 ;   And repeat with attributes to empty.                                  
 ; 
  (while (setq tex (nentsel "\nSelect attributes to empty: "))
         (if (= "ATTRIB" (cdr (assoc 0 (entget (car tex)))))
             (progn
                  (if (null atsav) (setq atsav (car tex)))
                  (princ (cdr (assoc 1 (setq e1 (entget (car tex))))))
                  (redraw (setq enam (cdr (assoc -1 e1))) 3)
                  (setq atnam (cdr (assoc 2 e1)))
                  (setq datlst (cons (cons atnam "") datlst))
                  (setq texlst (cons enam texlst)))))
 ; Ŀ
 ;   Find the name of the block.                                           
 ; 
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget (setq atsav
                                                         (entnext atsav))))))))
  (setq blanam (cdr (assoc 2 (entget (cdr (assoc -2 entt))))))
 ; Ŀ
 ;   De-highlight the selected attributes.                                 
 ; 
  (while (setq enam (car texlst))
         (redraw enam)
         (setq texlst (cdr texlst)))
 ; Ŀ
 ;   Make up the text lines for the header.                                
 ; 
  (setq aa (strcat (strcase (substr prognm 1 1))
                   (strcase (substr prognm 2) t)
                   " - replace values in the block "
                   (strcase (substr blanam 1 1))
                   (strcase (substr blanam 2) t)
                   "."))
  (setq bb "Written with Rocket Software's Du.lsp")
 ; Ŀ
 ;   Write the routine.                                                    
 ;   First call Bottle to do the header.                                   
 ; 
  (bottle lspnam (list aa bb))
 ; Ŀ
 ;   And add the code.                                                     
 ; 
  (setq fn (open lspnam "a"))
  (write-line (strcat "(DEFUN C:" (strcase prognm)
                    " (/ blanam datlst ss num esav enam entt val tag gnu)") fn)
  (write-line (strcat "(Setq blanam \"" blanam "\")") fn)
  (princ "(Setq datlst '(" fn)
  (while (setq sub (car datlst))
         (print sub fn)
         (setq datlst (cdr datlst)))
  (princ "))" fn)
  (print code1 fn)
  (print code2 fn)
  (print code3 fn)
  (write-line "(princ))" fn)
  (close fn)
 (princ))